from aiohttp import web
import json

from .common import json_response, get_real_ip


class IdmCollection:
    ROLE_SLUG = 'role'
    PASSPORT_LOGIN_SLUG = 'passport-login'

    def __init__(self, sd):
        self.sd = sd

    async def get_info(self, _) -> web.Response:
        return json_response({
            'code': 0,
            'roles': {
                'slug': self.ROLE_SLUG,
                'name': {
                    'en': 'Role',
                    'ru': 'Роль'
                },
                'values': {
                    'manager': {
                        'name': {
                            'ru': 'Менеджер',
                            'en': 'Manager',
                        },
                        'help': {
                            'ru': 'Доступ ко всем агентствам',
                            'en': 'Access to all agencies'
                        }
                    }
                }
            },
            'fields': [
                {
                    'slug': self.PASSPORT_LOGIN_SLUG,
                    'name': {
                        'en': 'Passport login',
                        'ru': 'Паспортный логин',
                    },
                    'type': 'passportlogin',
                    'required': True,
                }
            ]
        })

    async def get_all_roles(self, _) -> web.Response:
        internal_roles = await self.sd.grants.get_all_internal_roles()

        users = []
        for role in internal_roles:
            users.append({
                "login": role.staff_login,
                "roles": [
                    [
                        {self.ROLE_SLUG: 'manager'},
                        {self.PASSPORT_LOGIN_SLUG: role.email.split('@')[0]}
                    ]
                ]
            })

        return json_response({
            'code': 0,
            'users': users
        })

    async def add_role(self, request: web.Request) -> web.Response:
        real_ip = get_real_ip(request)
        data = await request.post()

        fields = json.loads(data["fields"])

        passport_login = fields[self.PASSPORT_LOGIN_SLUG]

        await self.sd.grants.add_internal_role(
            staff_login=data['login'],
            email=f'{passport_login}@yandex.ru',
            real_ip=real_ip,
        )

        return json_response({
            'code': 0,
            'data': {self.PASSPORT_LOGIN_SLUG: passport_login}
        })

    async def remove_role(self, request: web.Request) -> web.Response:
        data = await request.post()

        fields = json.loads(data["fields"])

        await self.sd.grants.remove_internal_role(
            staff_login=data['login'],
            email=f'{fields[self.PASSPORT_LOGIN_SLUG]}@yandex.ru'
        )
        return json_response({'code': 0})
