from crm.agency_cabinet.common.enum import BaseEnum


class Permissions(BaseEnum):
    certification = 'certification'
    rewards = 'rewards'
    documents = 'documents'
    client_bonuses = 'client_bonuses'
    analytics = 'analytics'
    roles = 'roles'
    ord = 'ord'


class Roles(BaseEnum):
    manager = 'manager'
    owner = 'owner'
    suggested_user = 'suggested_user'
    admin = 'admin'
    ord = 'ord'


ROLE_TO_DISPLAY_NAME = {
    Roles.manager.value: 'Менеджер',
    Roles.owner.value: 'Главный представитель',
    Roles.suggested_user.value: 'Потенциальный пользователь',
    Roles.admin.value: 'Администратор',
    Roles.ord.value: 'Отчёты для маркировки',
}

ROLE_TO_DESCRIPTION = {
    Roles.manager.value: 'Менеджер агентства {}',
    Roles.owner.value: 'Главный представитель агентства {}',
    Roles.suggested_user.value: 'Потенциальный пользователь агентства {}',
    Roles.admin.value: 'Администратор агентства {}',
    Roles.ord.value: 'Отчёты для маркировки агентства {}',
}
