from sqlalchemy import and_
from crm.agency_cabinet.grants.server.src.db.models import User, Permission, RolesPermissionsMap, UserRole, PartnersRolesMap, UsersRolesPermissionsMap
from crm.agency_cabinet.grants.server.src.db import db
from crm.agency_cabinet.grants.server.bin.scripts.common import get_bind_context


async def add_role_to_user(yandex_uid: int, agency_id: int, role_key_name: str, permissions: list[str]):
    async with get_bind_context():
        user = await User.query.where(User.yandex_uid == yandex_uid).gino.first()
        if user is None:
            raise ValueError('UNKNOWN_UID %s')

        role = await db.select(
            [
                UserRole.id,
                UserRole.name,
            ]
        ).select_from(UserRole.join(PartnersRolesMap)).where(and_(PartnersRolesMap.agency_id == agency_id, UserRole.name == role_key_name)).gino.first()

        if role is None:
            raise ValueError('UNKNOWN_AGENCY_ROLE')

        check_exists = UsersRolesPermissionsMap.query.where(and_(UsersRolesPermissionsMap.role_id == role.id, UsersRolesPermissionsMap.user_id == user.id)).gino.all()
        if check_exists:
            raise ValueError('ROLE_GRANTED_ALREADY')

        all_permissions_map = {p.id: p.name for p in await Permission.query.gino.all()}
        role_permissions = await RolesPermissionsMap.query.where(RolesPermissionsMap.role_id == role.id).gino.all()
        permissions = set(permissions)
        async with db.transaction(read_only=False, reuse=False):
            for role_permission in role_permissions:
                name = all_permissions_map.get(role_permission.permission_id)
                if not role_permission.is_editable and name not in permissions:
                    raise ValueError(f'MANDATORY_{name.upper()}_PERMISSION')
                await UsersRolesPermissionsMap.create(
                    user_id=user.id,
                    role_id=role.id,
                    permission_id=role_permission.permission_id,
                    is_editable=role_permission.is_editable,
                    is_active=name in permissions
                )
