from gino.dialects.asyncpg import Pyscopg2Pool
from crm.agency_cabinet.common.utils.nullcontext import NullContext
from crm.agency_cabinet.grants.server.src.db import db
from crm.agency_cabinet.grants.server.src.config import GrantsConfig, Settings


def get_bind_context():
    if db._bind is None:
        cfg = GrantsConfig.from_environ()
        return db.with_bind(bind=str(cfg.db.get_dsn()), pool_class=Pyscopg2Pool, ssl=Settings.db['ssl'])
    else:
        return NullContext()
