import os
import sys
from alembic.config import CommandLine, Config
from library.python import resource

from crm.agency_cabinet.common.server.rpc.config import DbConfig
from .settings import MIGRATIONS_REL_PATH, MIGRATIONS_ABS_PATH


def extract_resources():
    for res, data in resource.iteritems(prefix='resfs/file/{}'.format(MIGRATIONS_REL_PATH), strip_prefix=True):
        path = os.path.join(MIGRATIONS_ABS_PATH, res)

        if not os.path.exists(path):
            parent = os.path.normpath(os.path.join(path, os.pardir))
            if not os.path.exists(parent):
                os.makedirs(parent)
            with open(path, 'wb') as f:
                f.write(data)


# TODO вынести main в common, передавать MIGRATIONS_ABS_PATH и MIGRATIONS_REL_PATH в аргументах
def main():
    extract_resources()

    cl = CommandLine()
    options = cl.parser.parse_args(sys.argv[1:])

    cfg = Config(
        file_='{}/alembic.ini'.format(MIGRATIONS_ABS_PATH),
        ini_section=options.name,
        cmd_opts=options,
    )

    cfg.set_main_option('script_location', MIGRATIONS_ABS_PATH)
    cfg.set_main_option('version_locations', '{}/versions'.format(MIGRATIONS_ABS_PATH))

    db_config = DbConfig.from_environ()
    url = "postgresql+psycopg2://{user}:{password}@/{dbname}?host={host}&port={port}&" \
          "target_session_attrs=read-write".format(user=db_config.user,
                                                    password=db_config.password,
                                                    dbname=db_config.database,
                                                    host=db_config.host,
                                                    port=db_config.port)

    cfg.set_main_option('sqlalchemy.url', url)

    sys.exit(cl.run_cmd(cfg, options))


if __name__ == '__main__':
    main()
