"""Added person

Revision ID: d97c5b405d0a
Revises:
Create Date: 2021-06-21 11:07:07.862511+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv


# revision identifiers, used by Alembic.
revision = 'd97c5b405d0a'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute('CREATE SCHEMA IF NOT EXISTS grants')

    op.create_table('role',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('yandex_uid', sa.BigInteger(), nullable=False, unique=True),
                    sa.Column('staff_login', sa.Text(), nullable=True, unique=True),
                    sa.Column('email', sa.Text(), nullable=False),
                    sa.Column('agency_id', sa.BigInteger(), nullable=True),
                    sa.Column('is_main', sa.Boolean(), server_default='f', nullable=False),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'),
                              nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'),
                              nullable=False),
                    sa.PrimaryKeyConstraint('id'),
                    schema='grants'
                    )

    op.create_index(
        'role__is_main_yandex_uid__idx',
        'role',
        ['agency_id'],
        unique=True,
        postgresql_where=sa.text('is_main IS true'),
        schema='grants'
    )

    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('role__is_main_yandex_uid__idx', table_name='role')

    op.drop_table('role')

    op.execute('DROP SCHEMA IF EXIST grants')
    # ### end Alembic commands ###
