"""Made email nullable and added tools_yt_sync

Revision ID: 664c12f9957d
Revises: d97c5b405d0a
Create Date: 2021-08-12 12:09:09.940494+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv

# revision identifiers, used by Alembic.
revision = '664c12f9957d'
down_revision = 'd97c5b405d0a'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('tools_yt_sync',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('path', sa.Text(), nullable=True),
                    sa.Column('last_used_update', sa.DateTime(timezone=True), nullable=True),
                    sa.Column('enabled', sa.Boolean(), server_default='t', nullable=True),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'),
                              nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'),
                              nullable=False),
                    sa.PrimaryKeyConstraint('id', name=op.f('tools_yt_sync__pk')),
                    sa.UniqueConstraint('path', name=op.f('tools_yt_sync__path__uq')),
                    schema='grants'
                    )
    op.create_index('tools_yt_sync__path__idx', 'tools_yt_sync', ['path'], unique=False, schema='grants')
    op.alter_column('role', 'email',
                    existing_type=sa.TEXT(),
                    nullable=True,
                    schema='grants')
    op.create_index('role__is_main_agency_id__idx', 'role', ['agency_id'], unique=True, schema='grants',
                    postgresql_where=sa.text('is_main IS true'))
    op.drop_index('role__is_main_yandex_uid__idx', table_name='role', schema='grants')
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index('role__is_main_yandex_uid__idx', 'role', ['agency_id'], unique=True, schema='grants')
    op.drop_index('role__is_main_agency_id__idx', table_name='role', schema='grants')
    op.alter_column('role', 'email',
                    existing_type=sa.TEXT(),
                    nullable=False,
                    schema='grants')
    op.drop_index('tools_yt_sync__path__idx', table_name='tools_yt_sync', schema='grants')
    op.drop_table('tools_yt_sync', schema='grants')
    # ### end Alembic commands ###
