"""role_model

Revision ID: d57654d99710
Revises: 8cd62b010e9d
Create Date: 2021-11-17 01:44:52.424923+00:00

"""
from alembic import op
import platform
import sqlalchemy as sa
import yenv



# revision identifiers, used by Alembic.
revision = 'd57654d99710'
down_revision = '8cd62b010e9d'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    if yenv.type != 'development' or platform.system() != 'Darwin':
        collation = 'C.UTF-8'
    else:
        collation = 'ru_RU.UTF-8'

    op.create_table('permission',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('name', sa.Text(), nullable=False),
                    sa.Column('description', sa.Text(), nullable=True),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'),
                              nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'),
                              nullable=False),
                    sa.PrimaryKeyConstraint('id', name=op.f('permission__pk')),
                    sa.UniqueConstraint('name', name=op.f('permission__name__uq')),
                    schema='grants'
                    )
    op.create_table('user',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('yandex_uid', sa.BigInteger(), nullable=False),
                    sa.Column('email', sa.Text(), nullable=True),
                    sa.Column('display_name', sa.Text(collation=collation), nullable=True),
                    sa.Column('avatar_id', sa.Text(), nullable=True),
                    sa.Column('type', sa.Text(), nullable=False),
                    sa.Column('staff_login', sa.Text(), nullable=True),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'),
                              nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'),
                              nullable=False),
                    sa.PrimaryKeyConstraint('id', name=op.f('user__pk')),
                    sa.UniqueConstraint('yandex_uid', name=op.f('user__yandex_uid__uq')),
                    schema='grants'
                    )
    op.create_table('user_role',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('name', sa.Text(), nullable=False),
                    sa.Column('description', sa.Text(), nullable=True),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'),
                              nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'),
                              nullable=False),
                    sa.PrimaryKeyConstraint('id', name=op.f('user_role__pk')),
                    schema='grants'
                    )
    op.create_table('agencies_roles_map',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('agency_id', sa.BigInteger(), nullable=True),
                    sa.Column('role_id', sa.BigInteger(), nullable=True),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'),
                              nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'),
                              nullable=False),
                    sa.ForeignKeyConstraint(['role_id'], ['grants.user_role.id'],
                                            name=op.f('agencies_roles_map_user_role__role_id__fk')),
                    sa.PrimaryKeyConstraint('id', name=op.f('agencies_roles_map__pk')),
                    schema='grants'
                    )
    op.create_index('agencies_roles_map__agency_id_role_id__idx', 'agencies_roles_map', ['agency_id', 'role_id'],
                    unique=True, schema='grants')
    op.create_table('idm_group',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('key', sa.Text(), nullable=True),
                    sa.Column('name', sa.Text(), nullable=True),
                    sa.Column('role_id', sa.BigInteger(), nullable=True),
                    sa.Column('description', sa.Text(), nullable=True),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'),
                              nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'),
                              nullable=False),
                    sa.ForeignKeyConstraint(['role_id'], ['grants.user_role.id'],
                                            name=op.f('idm_group_user_role__role_id__fk')),
                    sa.PrimaryKeyConstraint('id', name=op.f('idm_group__pk')),
                    sa.UniqueConstraint('key', name=op.f('idm_group__key__uq')),
                    schema='grants'
                    )
    op.create_table('roles_permissions_map',
                    sa.Column('permission_id', sa.BigInteger(), nullable=False),
                    sa.Column('role_id', sa.BigInteger(), nullable=False),
                    sa.Column('is_editable', sa.Boolean(), server_default='f', nullable=True),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'),
                              nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'),
                              nullable=False),
                    sa.ForeignKeyConstraint(['permission_id'], ['grants.permission.id'],
                                            name=op.f('roles_permissions_map_permission__permission_id__fk')),
                    sa.ForeignKeyConstraint(['role_id'], ['grants.user_role.id'],
                                            name=op.f('roles_permissions_map_user_role__role_id__fk')),
                    sa.PrimaryKeyConstraint('role_id', 'permission_id', name=op.f('roles_permissions_map__pk')),
                    sa.UniqueConstraint('role_id', 'permission_id', 'is_editable',
                                        name=op.f('roles_permissions_map__role_id__uq')),
                    schema='grants'
                    )
    op.create_table('users_roles_permissions_map',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('user_id', sa.BigInteger(), nullable=False),
                    sa.Column('role_id', sa.BigInteger(), nullable=False),
                    sa.Column('permission_id', sa.BigInteger(), nullable=True),
                    sa.Column('is_editable', sa.Boolean(), server_default='f', nullable=True),
                    sa.Column('is_active', sa.Boolean(), server_default='t', nullable=False),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'),
                              nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'),
                              nullable=False),
                    sa.ForeignKeyConstraint(['role_id', 'permission_id', 'is_editable'],
                                            ['grants.roles_permissions_map.role_id',
                                             'grants.roles_permissions_map.permission_id',
                                             'grants.roles_permissions_map.is_editable'], name=op.f(
                            'users_roles_permissions_map_roles_permissions_map__role_id__fk')),
                    sa.ForeignKeyConstraint(['role_id'], ['grants.user_role.id'],
                                            name=op.f('users_roles_permissions_map_user_role__role_id__fk')),
                    sa.ForeignKeyConstraint(['user_id'], ['grants.user.id'],
                                            name=op.f('users_roles_permissions_map_user__user_id__fk')),
                    sa.PrimaryKeyConstraint('id', name=op.f('users_roles_permissions_map__pk')),
                    schema='grants'
                    )
    op.create_index('users_roles_permissions_map__user_id_role_id_permission_id_idx', 'users_roles_permissions_map', ['user_id', 'role_id', 'permission_id'], unique=True, schema='grants')
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        'users_roles_permissions_map__user_id_role_id_permission_id_idx',
        table_name='users_roles_permissions_map', schema='grants'
    )
    op.drop_table('users_roles_permissions_map', schema='grants')
    op.drop_table('roles_permissions_map', schema='grants')
    op.drop_table('idm_group', schema='grants')
    op.drop_index('agencies_roles_map__agency_id_role_id__idx', table_name='agencies_roles_map', schema='grants')
    op.drop_table('agencies_roles_map', schema='grants')
    op.drop_table('user_role', schema='grants')
    op.drop_table('user', schema='grants')
    op.drop_table('permission', schema='grants')
    # ### end Alembic commands ###
