"""display_name

Revision ID: 092e5e931c44
Revises: 0974e3b9411f
Create Date: 2022-02-09 13:44:54.986559+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv



# revision identifiers, used by Alembic.
revision = '092e5e931c44'
down_revision = '0974e3b9411f'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('user_role', sa.Column('display_name', sa.Text(), nullable=False, server_default=''), schema='grants')
    op.execute(
        '''
            UPDATE grants.user_role
            SET display_name =
                CASE
                    WHEN "name" = 'admin' THEN 'Администратор'
                    WHEN "name" = 'owner' THEN 'Главный представитель'
                    WHEN "name" = 'manager' THEN 'Менеджер'
                    WHEN "name" = 'suggested_user' THEN 'Потенциальный пользователь'
                END
            ;
        '''
    )
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('user_role', 'display_name', schema='grants')
    # ### end Alembic commands ###
