"""partners

Revision ID: a6a1a25f0322
Revises: 092e5e931c44
Create Date: 2022-06-15 14:48:55.598929+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv
import platform



# revision identifiers, used by Alembic.
revision = 'a6a1a25f0322'
down_revision = '092e5e931c44'
branch_labels = None
depends_on = None


def upgrade():
    if yenv.type != 'development' or platform.system() != 'Darwin':
        collation = 'C.UTF-8'
    else:
        collation = 'ru_RU.UTF-8'
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('partner',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('name', sa.Text(collation=collation), nullable=False, server_default=''),
    sa.Column('external_id', sa.Text(), nullable=True),
    sa.Column('type', sa.Text(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('partner__pk')),
    schema='grants'
    )
    op.create_index('partner_type_external_id__idx', 'partner', ['type', 'external_id'], unique=True, schema='grants')
    op.add_column('agencies_roles_map', sa.Column('partner_id', sa.BigInteger(), nullable=True), schema='grants')
    op.create_foreign_key(op.f('agencies_roles_map_partner__partner_id__fk'), 'agencies_roles_map', 'partner', ['partner_id'], ['id'], source_schema='grants', referent_schema='grants')
    op.execute('SET search_path TO grants')
    op.execute("""
        INSERT INTO partner(id, external_id, "type")
        SELECT nextval('partner_id_seq'::regclass) as partner_id, agency_id::text, 'agency' as agency_type
        FROM (SELECT DISTINCT agency_id as agency_id FROM agencies_roles_map) as ids;
    """)
    op.execute('ALTER SEQUENCE agencies_roles_map_id_seq RENAME TO partners_roles_map_id_seq')
    op.execute('ALTER INDEX agencies_roles_map__pk RENAME TO partners_roles_map__pk')
    op.execute('ALTER INDEX agencies_roles_map__agency_id_role_id__idx RENAME TO partners_roles_map_id_seq__agency_id_role_id__idx')
    op.execute('ALTER TABLE agencies_roles_map RENAME CONSTRAINT agencies_roles_map_user_role__role_id__fk TO partners_roles_map__role_id__fk')
    op.rename_table('agencies_roles_map', 'partners_roles_map')
    op.execute("""
        UPDATE partners_roles_map AS a
        SET partner_id = b.id
        FROM partner AS b
        WHERE b."type" = 'agency' AND a.agency_id = CAST(b.external_id AS integer)
    """)
    op.create_index('partners_roles_map__partner_id_role_id__idx', 'partners_roles_map', ['partner_id', 'role_id'],
                    unique=True, schema='grants')
    op.execute('SET search_path TO public')

    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.execute('SET search_path TO grants')
    op.execute('ALTER SEQUENCE partners_roles_map_id_seq RENAME TO agencies_roles_map_id_seq')
    op.execute('ALTER INDEX partners_roles_map__pk RENAME TO agencies_roles_map__pk')
    op.execute(
        'ALTER INDEX partners_roles_map_id_seq__agency_id_role_id__idx RENAME TO agencies_roles_map__agency_id_role_id__idx')
    op.execute(
        'ALTER TABLE partners_roles_map RENAME CONSTRAINT partners_roles_map__role_id__fk TO agencies_roles_map_user_role__role_id__fk')
    op.rename_table('partners_roles_map', 'agencies_roles_map')
    op.execute('SET search_path TO public')
    op.drop_constraint(op.f('agencies_roles_map_partner__partner_id__fk'), 'agencies_roles_map', schema='grants', type_='foreignkey')
    op.drop_column('agencies_roles_map', 'partner_id', schema='grants')
    op.drop_index('partner_type_external_id__idx', table_name='partner', schema='grants')
    op.drop_index('partners_roles_map__partner_id_role_id__idx', table_name='partners_roles_map', schema='grants')
    op.drop_table('partner', schema='grants')
    # ### end Alembic commands ###
