"""empty message

Revision ID: 7678169058de
Revises: a6a1a25f0322
Create Date: 2022-07-15 12:57:20.903414+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv

# revision identifiers, used by Alembic.
revision = '7678169058de'
down_revision = 'a6a1a25f0322'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('app_oauth',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('partner_id', sa.BigInteger(), nullable=False),
                    sa.Column('app_id', sa.Text(), nullable=False),
                    sa.Column('is_active', sa.Boolean(), nullable=False),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'),
                              nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'),
                              nullable=False),
                    sa.PrimaryKeyConstraint('id', name=op.f('app_oauth__pk')),
                    sa.UniqueConstraint('app_id', name=op.f('app_oauth__app_id__uq')),
                    sa.ForeignKeyConstraint(['partner_id'], ['grants.partner.id'], name=op.f('app_oauth__partner_id__fk')),
                    schema='grants'
                    )
    op.create_table('oauth_permissions_map',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('oauth_id', sa.BigInteger(), nullable=False),
                    sa.Column('permission_id', sa.BigInteger(), nullable=True),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'),
                              nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'),
                              nullable=False),
                    sa.ForeignKeyConstraint(['oauth_id'], ['grants.app_oauth.id'],
                                            name=op.f('oauth_permissions_map_app_oauth__oauth_id__fk')),
                    sa.ForeignKeyConstraint(['permission_id'], ['grants.permission.id'],
                                            name=op.f('oauth_permissions_map_permission__permission_id__fk')),
                    sa.PrimaryKeyConstraint('id', name=op.f('oauth_permissions_map__pk')),
                    schema='grants'
                    )
    op.create_index('oauth_permissions_map__user_id_role_id_permission_id_idx', 'oauth_permissions_map',
                    ['oauth_id', 'permission_id'], unique=True, schema='grants')
    op.create_index('partners_roles_map__agency_id_role_id__idx', 'partners_roles_map', ['agency_id', 'role_id'],
                    unique=True, schema='grants')
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('partners_roles_map__agency_id_role_id__idx', table_name='partners_roles_map', schema='grants')
    op.drop_index('oauth_permissions_map__user_id_role_id_permission_id_idx', table_name='oauth_permissions_map',
                  schema='grants')
    op.drop_table('oauth_permissions_map', schema='grants')
    op.drop_table('app_oauth', schema='grants')
    # ### end Alembic commands ###
