import logging

from yt.wrapper import YtClient
from yql.api.v1.client import YqlClient

from crm.agency_cabinet.common.celery.base import async_to_sync
from crm.agency_cabinet.grants.server.src import config
from crm.agency_cabinet.grants.server.src.celery.base import celery_app as celery


from .loader import AgencyPartnersLoader


LOGGER = logging.getLogger('celery.load_users_task')

BASE_SOURCE_PATH = '//home/direct/mysql-sync/current'


@celery.task(bind=True)
def load_agency_partners_task(self):
    @async_to_sync
    async def _load_agency_partners():
        client_config = {
            'cluster': 'hahn',
            'token': config.YT_CONFIG['TOKEN'],
            'config': {}
        }

        yt_client = YtClient(
            proxy=client_config['cluster'],
            token=client_config['token'],
            config=client_config.get('config')
        )

        yql_client = YqlClient(token=config.YQL_CONFIG['TOKEN'])

        agencies_loader = AgencyPartnersLoader(yt_client, yql_client)
        return await agencies_loader.load()

    result = _load_agency_partners()
    LOGGER.info('Finished sync for AgencyPartnersLoader. Success: %s', result)
