import logging

from yql.api.v1.client import YqlClient
from yql.client.parameter_value_builder import YqlParameterValueBuilder
from yt.wrapper import YtClient

from crm.agency_cabinet.common.yt.loaders import YqlLoader

from .synchronizer import UsersSynchronizer


LOGGER = logging.getLogger('celery.load_users')


class UsersLoader(YqlLoader):

    YQL_QUERY = '''
        use hahn;

        DECLARE $clients_table_path AS String;
        DECLARE $users_table_path AS String;

        $agencies = (SELECT
            clients.`ClientID` as agency_id
        FROM $clients_table_path as clients
        WHERE clients.role = 'agency'
        );

        SELECT
            users.`ClientID` as agency_id,
            AGGREGATE_LIST(
                 AsStruct(
                    `uid` as uid,
                    `email` as email,
                    `FIO` as fio,
                    `login` as login,
                    `rep_type` as rep_type
                )
            ) as users_list
        FROM $users_table_path as users
        JOIN $agencies as agencies on agencies.agency_id = users.`ClientID`
        group by users.`ClientID`;
    '''

    def __init__(self, yt_client: YtClient, yql_client: YqlClient, clients_table_path: str, users_table_path: str):
        super().__init__(
            yt_client, yql_client,
            yql_parameters={
                '$clients_table_path': YqlParameterValueBuilder.make_string(clients_table_path),
                '$users_table_path': YqlParameterValueBuilder.make_string(users_table_path)
            },
            table_paths=[clients_table_path, users_table_path]
        )

    async def _load(self, *args, **kwargs) -> bool:
        results = await self._get_results()
        agencies_users = results.table.get_iterator()

        return await UsersSynchronizer().process_data(agencies_users)
