import environ

from environs import Env
from gino.dialects.asyncpg import Pyscopg2Pool
from sqlalchemy.engine.url import URL

from crm.agency_cabinet.common.blackbox import BlackboxConfig
from crm.agency_cabinet.common.server.common.tvm import Tvm2Config
from crm.agency_cabinet.common.server.rpc.config import RpcServerConfig

env = Env()

gino_metadata_settings = {
    'schema': 'grants',
    'naming_convention': {
        'ix': '%(table_name)__%(column_0_name)s__idx',
        'uq': '%(table_name)s__%(column_0_name)s__uq',
        'ck': '%(table_name)s__%(constraint_name)s__ck',
        'fk': '%(table_name)s_%(referred_table_name)s__%(column_0_name)s__fk',
        'pk': '%(table_name)s__pk'
    }
}

YT_CONFIG = {
    'TOKEN': env('YT_TOKEN', None)
}

YQL_CONFIG = {
    'TOKEN': env('YQL_TOKEN', None)
}


@environ.config(prefix='')
class GrantsConfig(RpcServerConfig):
    tvm2 = environ.group(Tvm2Config)
    blackbox = environ.group(BlackboxConfig)


class Settings:
    db = {
        'dsn': URL(
            drivername='postgresql',
            username=env('PG_LOCAL_USER', 'postgres'),
            password=env('PG_LOCAL_PASSWORD', 'postgres'),
            host=env('PG_LOCAL_HOST', 'localhost'),
            port=env.int('PG_LOCAL_PORT', 5432),
            database=env('PG_LOCAL_DATABASE', 'postgres'),
        ),
        'ssl': env('PG_SSL', 'verify-full'),
        'pool_class': Pyscopg2Pool
    }

    gino_metadata_settings = {
        'schema': 'grants',
        'naming_convention': {
            'ix': '%(table_name)__%(column_0_name)s__idx',
            'uq': '%(table_name)s__%(column_0_name)s__uq',
            'ck': '%(table_name)s__%(constraint_name)s__ck',
            'fk': '%(table_name)s_%(referred_table_name)s__%(column_0_name)s__fk',
            'pk': '%(table_name)s__pk'
        }
    }


db_config = Settings()

SQS_SETTINGS = {
    'SQS_ACCESS_KEY': env('AWS_ACCESS_KEY_ID', 'agency-cabinet-test'),
    'SQS_SECRET_KEY': env('AWS_SECRET_ACCESS_KEY', 'unused'),
    'SQS_URL': env('SQS_URL', 'sqs.yandex.net:8771'),
    'SQS_OAUTH_TOKEN': env('AWS_SESSION_TOKEN', '')

}
# TODO: сделать, чтобы было без этой фигни (см. патч в chats/понять почему работает в аддаптере?)
# IMPORTANT: DO NOT SPECIFY NEITHER ACCESS_KEY NOR SECRET_KEY HERE
# They should be passed with session token in env vars, otherwise celery will
# take them from params, ignoring session token in env var
SQS_ENDPOINT = f'sqs://{SQS_SETTINGS["SQS_URL"]}'

CELERY_SETTINGS = {
    'broker_url': SQS_ENDPOINT if env.bool('USE_SQS', True) else env('BROKER_URL', 'redis://localhost:6379'),
    'result_expires': None,  # despite we don't use result_backend (i.e. DisabledBackend), celery beat generates
    'task_routes': {              # task to clean up dummy backend; remove if/when we use result_backend
        'crm.agency_cabinet.grants.server.src.celery.tasks.*': {
            'queue': 'grants'
        }
    },
    'imports': ['crm.agency_cabinet.common.celery.signals', 'crm.agency_cabinet.grants.server.src.celery.tasks'],
    'beat_schedule': {
        'load_agencies_representatives_roles': {
            'task': 'crm.agency_cabinet.grants.server.src.celery.tasks.load_users.load_users_task',
            'schedule': env.float('CELERYBEAT_LOAD_USERS_INTERVAL', 12*60*60),
            'options': {
                'queue': 'grants'
            }
        },
    },
    'beat_scheduler': 'crm.agency_cabinet.common.celery.scheduler.LockedPersistentScheduler',
    'broker_transport_options': {
        'is_secure': False,
        'region': 'yandex',
    }
}

# TODO: move to common
SCHEDULER_LOCK_SETTINGS = {
    'proxy': env('SCHEDULER_LOCK_PROXY', 'freud'),
    'prefix': env('SCHEDULER_LOCK_PREFIX', 'tmp'),
    'token': env('YT_TOKEN', None),
    'lock_params': {
        'lock_key': env('SCHEDULER_LOCK_KEY', 'grants-celerybeat-lock'),  # + env?
        'next_try_timeout': 30
    }
}
