from dataclasses import dataclass
from typing import List

from crm.agency_cabinet.grants.common.consts import Roles, Permissions, ROLE_TO_DISPLAY_NAME, ROLE_TO_DESCRIPTION
from crm.agency_cabinet.grants.server.src.db import models


@dataclass
class RoleSpec:
    role: Roles
    permissions: List[Permissions]
    is_editable: bool


async def create_role(partner_id: int, partner_name: str, role_spec: RoleSpec, permissions_map: dict = None):
    if not permissions_map:
        permissions = await models.Permission.query.gino.all()
        permissions_map = {Permissions(p.name): p.id for p in permissions}

    role_model = await models.UserRole.create(
        name=role_spec.role.value,
        display_name=ROLE_TO_DISPLAY_NAME[role_spec.role.value],
        description=ROLE_TO_DESCRIPTION[role_spec.role.value].format(partner_name)
    )
    await models.PartnersRolesMap.create(
        role_id=role_model.id,
        partner_id=partner_id
    )
    for permission in role_spec.permissions:
        await models.RolesPermissionsMap.create(
            permission_id=permissions_map[permission],
            role_id=role_model.id,
            is_editable=role_spec.is_editable
        )
