from crm.agency_cabinet.common.db.models import BaseModel, db


class IDMGroup(BaseModel):
    __tablename__ = 'idm_group'

    id = db.Column(db.BigInteger, primary_key=True)
    key = db.Column(db.Text, unique=True)
    name = db.Column(db.Text)
    role_id = db.Column(db.BigInteger)

    description = db.Column(db.Text, nullable=True)

    __table_args__ = (
        db.ForeignKeyConstraint(['role_id'], ['user_role.id'])
    )

    # ручка IDM должна будет по группе выдавать роль
    # role_id (которая дает базовый доступ к нескольким агентствам)
