from crm.agency_cabinet.common.db.models import BaseModel, db


class AppOAuth(BaseModel):
    __tablename__ = 'app_oauth'

    id = db.Column(db.BigInteger, primary_key=True)
    partner_id = db.Column(db.BigInteger, nullable=False)
    app_id = db.Column(db.Text, nullable=False, unique=True)
    is_active = db.Column(db.Boolean, nullable=False, default=True)

    __table_args__ = (
        db.ForeignKeyConstraint(['partner_id'], ['partner.id']),
    )


class OAuthPermissionsMap(BaseModel):
    __tablename__ = 'oauth_permissions_map'

    id = db.Column(db.BigInteger, primary_key=True)
    oauth_id = db.Column(db.BigInteger, nullable=False)
    permission_id = db.Column(db.BigInteger, nullable=True)

    __table_args__ = (
        db.Index('oauth_permissions_map__user_id_role_id_permission_id_idx', 'oauth_id', 'permission_id', unique=True),
        db.ForeignKeyConstraint(['oauth_id'], ['app_oauth.id']),
        db.ForeignKeyConstraint(['permission_id'], ['permission.id']),
    )
