from crm.agency_cabinet.common.db.models import BaseModel, db


class Partner(BaseModel):
    __tablename__ = 'partner'

    id = db.Column(db.BigInteger, primary_key=True)
    name = db.Column(db.Text(collation='C.UTF-8'), nullable=False, server_default='')
    external_id = db.Column(db.Text, nullable=True)
    type = db.Column(db.Text, nullable=False)

    __table_args__ = (
        db.Index(
            'partner_type_external_id__idx',
            'type',
            'external_id',
            unique=True
        ),
    )
