from crm.agency_cabinet.common.db.models import BaseModel, db
# from .role import UserRole  # noqa


class PartnersRolesMap(BaseModel):
    __tablename__ = 'partners_roles_map'

    id = db.Column(db.BigInteger, primary_key=True)
    agency_id = db.Column(db.BigInteger, nullable=True)
    # роль дает базовый доступ ко всем агентствам, если agency_id: NULL (и у роли есть хотя бы один любой permission)

    partner_id = db.Column(db.BigInteger, nullable=True)

    role_id = db.Column(db.BigInteger)

    __table_args__ = (
        db.Index(
            'partners_roles_map__agency_id_role_id__idx',
            'agency_id',
            'role_id',
            unique=True
        ),
        db.Index(
            'partners_roles_map__agency_id_role_id__idx',
            'partner_id',
            'role_id',
            unique=True
        ),
        db.ForeignKeyConstraint(['role_id'], ['user_role.id']),
        db.ForeignKeyConstraint(['partner_id'], ['partner.id'])
    )

    # пользователь имеет базовый доступ к агентству, если у него есть любая роль с agency_id
    # роль может давать доступ к нескольким агентствам
