from crm.agency_cabinet.common.db.models import BaseModel, db
from crm.agency_cabinet.grants.common.consts import ROLE_TO_DISPLAY_NAME


class Role(BaseModel):
    __tablename__ = 'role'

    id = db.Column(db.BigInteger, primary_key=True)
    agency_id = db.Column(db.BigInteger, nullable=True)
    yandex_uid = db.Column(db.BigInteger, nullable=False, unique=True)
    staff_login = db.Column(db.Text, nullable=True, unique=True)
    email = db.Column(db.Text, nullable=True)
    is_main = db.Column(db.Boolean, nullable=False, server_default='f', default=False)
    is_active = db.Column(db.Boolean, nullable=False, server_default='t', default=True)

    __table_args__ = (
        db.Index(
            'role__is_main_agency_id__idx',
            'agency_id',
            postgresql_where=(is_main.is_(True)),
            unique=True
        ),
    )


def default_display_name(context):
    return ROLE_TO_DISPLAY_NAME.get(context.get_current_parameters()['name'])


class UserRole(BaseModel):
    __tablename__ = 'user_role'

    id = db.Column(db.BigInteger, primary_key=True)
    name = db.Column(db.Text, nullable=False)
    description = db.Column(db.Text, nullable=True)
    display_name = db.Column(db.Text, nullable=False, default=default_display_name, server_default='')
