from crm.agency_cabinet.common.db.models import BaseModel, db
# from .permission import Permission  # noqa
# from .role import UserRole  # noqa


class RolesPermissionsMap(BaseModel):
    __tablename__ = 'roles_permissions_map'

    permission_id = db.Column(db.BigInteger)
    role_id = db.Column(db.BigInteger)

    is_editable = db.Column(db.Boolean, default=False, server_default='f')

    __table_args__ = (
        db.PrimaryKeyConstraint('role_id', 'permission_id'),
        db.UniqueConstraint('role_id', 'permission_id', 'is_editable'),
        db.ForeignKeyConstraint(['permission_id'], ['permission.id']),
        db.ForeignKeyConstraint(['role_id'], ['user_role.id'])
    )
