from crm.agency_cabinet.common.db.models import BaseModel, db


class User(BaseModel):
    __tablename__ = 'user'

    id = db.Column(db.BigInteger, primary_key=True)
    yandex_uid = db.Column(db.BigInteger, nullable=False, unique=True)
    email = db.Column(db.Text, nullable=True)
    display_name = db.Column(db.Text(collation='C.UTF-8'), nullable=True)
    login = db.Column(db.Text, nullable=True)
    avatar_id = db.Column(db.Text, nullable=True)
    type = db.Column(db.Text, nullable=False)  # add check constraint; "yandex", "external"

    # inner yandex user stuff
    staff_login = db.Column(db.Text, nullable=True)
