from crm.agency_cabinet.common.db.models import BaseModel, db
# from .permission import Permission  # noqa
# from .user import User  # noqa


class UsersRolesPermissionsMap(BaseModel):
    __tablename__ = 'users_roles_permissions_map'

    id = db.Column(db.BigInteger, primary_key=True)

    user_id = db.Column(db.BigInteger, nullable=False)
    role_id = db.Column(db.BigInteger, nullable=False)
    permission_id = db.Column(db.BigInteger, nullable=True)  # для ролей без permission

    is_editable = db.Column(db.Boolean, default=False, server_default='f')
    is_active = db.Column(db.Boolean, nullable=False, server_default='t', default=True)

    __table_args__ = (
        db.Index('users_roles_permissions_map__user_id_role_id_permission_id_idx', 'user_id', 'role_id', 'permission_id', unique=True),
        # db.PrimaryKeyConstraint('user_id', 'role_id', 'permission_id'),
        db.ForeignKeyConstraint(['user_id'], ['user.id']),
        db.ForeignKeyConstraint(['role_id'], ['user_role.id']),
        db.ForeignKeyConstraint(['permission_id'], ['permission.id']),
        db.ForeignKeyConstraint(['role_id', 'permission_id', 'is_editable'], ['roles_permissions_map.role_id',
                                                                              'roles_permissions_map.permission_id',
                                                                              'roles_permissions_map.is_editable']),
        # TODO: add check constraint for is_active based on is_editable
    )
