
class BaseGrantsException(Exception):
    def __init__(self, message=None):
        self.message = message


class RoleManagerException(BaseGrantsException):
    pass


class ConflictRoleException(RoleManagerException):
    pass


class NoSuchRoleException(RoleManagerException):
    pass


class NoSuchUserException(RoleManagerException):
    pass


class NoSuchPermissionException(RoleManagerException):
    pass


class UnsuitablePermissionException(RoleManagerException):
    pass


class NotEditablePermissionModificationException(RoleManagerException):
    pass


class NoPermission(RoleManagerException):
    pass


class PartnerManagerException(BaseGrantsException):
    pass


class PartnerNotFound(PartnerManagerException):
    pass


class NoSuchOAuthTokenException(PartnerManagerException):
    pass


class InactiveOAuthToken(PartnerManagerException):
    pass


class NoSuchPartnerException(PartnerManagerException):
    pass
