PY3TEST()

OWNER(g:agency_cabinet_back)

SIZE(MEDIUM)

INCLUDE(${ARCADIA_ROOT}/crm/agency_cabinet/common/testing/recipes/postgresql/postgresql.inc)

DEPENDS(
    antiadblock/postgres_local/recipe
    crm/agency_cabinet/grants/server/migrations
)

PEERDIR(
    contrib/python/asynctest
    contrib/python/pytest-asyncio
    crm/agency_cabinet/grants/common
    crm/agency_cabinet/grants/server
    crm/agency_cabinet/common/testing
)

PY_SRCS(
    celery/load_partners/conftest.py
    celery/load_users/conftest.py
    handler/conftest.py
    conftest.py
)

TEST_SRCS(
    celery/load_partners/test_synchronizer.py
    celery/load_users/test_synchronizer.py
    handler/test_get_users_permissions.py
    handler/test_get_access_scope.py
    handler/test_edit_user.py
    handler/test_suggested_users.py
    handler/test_list_roles.py
    handler/test_check_permissions.py
    handler/test_list_user_roles.py
    handler/test_get_accessible_agencies.py
    handler/test_list_user_permissions.py
    handler/test_list_available_partners.py
    handler/test_get_partner.py
    handler/test_get_partner_id.py
    handler/test_check_oauth.py

    procedures/test_get_partner_id.py
    procedures/test_get_partner.py
    procedures/test_list_available_partners.py
    procedures/test_list_partners.py
    procedures/conftest.py
    procedures/test_check_oauth.py

    test_handler.py
)

IF(NOT OS_DARWIN)
    FORK_TEST_FILES()
ENDIF()


END()
