PY3_LIBRARY()

OWNER(
    g:agency_cabinet_back
)

PEERDIR(
    contrib/python/environs
    contrib/python/gino
    library/python/ylock
    yql/library/python

    crm/agency_cabinet/common/cache
    crm/agency_cabinet/common/consts
    crm/agency_cabinet/common/celery
    crm/agency_cabinet/common/config
    crm/agency_cabinet/common/db
    crm/agency_cabinet/common/monitoring
    crm/agency_cabinet/common/service_discovery
    crm/agency_cabinet/common/server/rpc
    crm/agency_cabinet/common/yt
    crm/agency_cabinet/common/yql
    crm/agency_cabinet/grants/common
    crm/agency_cabinet/grants/proto
    crm/agency_cabinet/rewards/common
)

PY_SRCS(
    src/celery/tasks/load_users/__init__.py
    src/celery/tasks/load_users/loader.py
    src/celery/tasks/load_users/synchronizer.py
    src/celery/tasks/load_partners/__init__.py
    src/celery/tasks/load_partners/loader.py
    src/celery/tasks/load_partners/synchronizer.py
    src/celery/tasks/__init__.py
    src/celery/__init__.py
    src/celery/base.py
    src/db/__init__.py
    src/db/engine.py
    src/db/queries.py
    src/db/helpers/__init__.py
    src/db/helpers/roles.py
    src/db/models/__init__.py
    src/db/models/partner.py
    src/db/models/role.py
    src/db/models/partners_roles_map.py
    src/db/models/idm_group.py
    src/db/models/oauth.py
    src/db/models/permission.py
    src/db/models/roles_permissions_map.py
    src/db/models/users_roles_permissions_map.py
    src/db/models/user.py
    src/procedures/role_manager.py
    src/procedures/partner_manager.py
    src/procedures/exceptions.py
    src/__init__.py
    src/config.py
    src/handler.py


)

END()

RECURSE_FOR_TESTS(tests)

RECURSE(
    bin
    migrations
)
