import itertools

from crm.agency_cabinet.common.monitoring.cli import cli_factory
from crm.agency_cabinet.common.monitoring.clusters import register as clusters_list
from crm.agency_cabinet.rewards.monitoring.registry.service import rewards
from crm.agency_cabinet.grants.monitoring.registry.service import grants
from crm.agency_cabinet.gateway.monitoring.registry.service import gateway
from crm.agency_cabinet.agencies.monitoring.registry.service import agencies
from crm.agency_cabinet.documents.monitoring.registry.service import documents
from crm.agency_cabinet.documents.monitoring.registry.shards import register as documents_shards_list
from crm.agency_cabinet.rewards.monitoring.registry.shards import register as rewards_shards_list
from crm.agency_cabinet.grants.monitoring.registry.shards import register as grants_shards_list
from crm.agency_cabinet.gateway.monitoring.registry.shards import register as gateway_shards_list
from crm.agency_cabinet.agencies.monitoring.registry.shards import register as agencies_shards_list
from crm.agency_cabinet.monitoring.registry.dashboards.main import register as common_dashboards_list
from crm.agency_cabinet.gateway.monitoring.registry.graphs import register as gateway_graphs_list

from crm.agency_cabinet.monitoring.registry.graphs import register as common_graphs_list


AGENCY_CABINET_ROBOT_SOLO_TOKEN_SECRET_ID = 'sec-01fjdpn6hwaax21fgtb11b0zdz'


def get_all_clusters():
    return clusters_list


def get_all_services():
    return [rewards, grants, gateway, agencies, documents]


def get_all_shards():
    return itertools.chain(rewards_shards_list, grants_shards_list, gateway_shards_list, agencies_shards_list, documents_shards_list)


def get_all_graphs():
    return [*gateway_graphs_list, *common_graphs_list]


def get_all_dashboards():
    return [*common_dashboards_list]


def get_production_objects_registry():
    return list(itertools.chain(
        # get_all_alerts(),
        # get_all_channels(),
        # get_all_checks(),
        get_all_clusters(),
        get_all_dashboards(),
        get_all_graphs(),
        get_all_services(),
        get_all_shards()
    ))


def get_solomon_objects(env_type):
    if env_type == 'test':
        # TODO: create test project for experiments?
        raise NotImplementedError()
    return get_production_objects_registry()


def main():
    cli_factory(
        AGENCY_CABINET_ROBOT_SOLO_TOKEN_SECRET_ID,
        get_solomon_objects,
        lambda e: None,
        lambda e: None,
        state_file_path="./solo.state"
    )()


if __name__ == '__main__':
    main()
