from library.python.monitoring.solo.objects.solomon.v2 import Dashboard, Row, Panel
from crm.agency_cabinet.common.monitoring.project import agency_cabinet_solomon_project
from crm.agency_cabinet.monitoring.registry.graphs.uptime import (
    prestable_uptime_graph,
    testing_uptime_graph,
    prod_uptime_graph,
)
from crm.agency_cabinet.monitoring.registry.graphs.sqs import (
    testing_sqs_message_count_graph,
    prestable_sqs_message_count_graph,
    prod_sqs_message_count_graph
)
from crm.agency_cabinet.gateway.monitoring.registry.graphs.http import (
    testing_gateway_rps_api_graph,
    prestable_gateway_rps_api_graph,
    prod_gateway_rps_api_graph,
    prestable_time_distribution_graph,
    prod_time_distribution_graph,
    testing_time_distribution_graph
)

main_dashboard_testing = Dashboard(
    id="agency_cabinet_main_dashboard_testing",
    project_id=agency_cabinet_solomon_project.id,
    name="Agency Cabinet Testing Services Dashboard",
    description="Основные метрики Агентского Кабинета (testing)",  # TODO: make factory
    rows=[
        Row(
            panels=[
                Panel(
                    url=testing_time_distribution_graph.get_dashboard_link(),
                    title="Response time distribution"
                ),
                Panel(
                    url=testing_gateway_rps_api_graph.get_dashboard_link(),
                    title="API RPS"
                )
            ]
        ),
        Row(
            panels=[
                Panel(
                    url=testing_uptime_graph.get_dashboard_link(),
                    title='Services Uptime'
                )
            ]
        ),
        Row(
            panels=[
                Panel(
                    url=testing_sqs_message_count_graph.get_dashboard_link(),
                    title='SQS'
                )
            ]
        )
    ]
)

main_dashboard_prestable = Dashboard(
    id="agency_cabinet_main_dashboard_prestable",
    project_id=agency_cabinet_solomon_project.id,
    name="Agency Cabinet Prestable Services Dashboard",
    description="Основные метрики Агентского Кабинета (prestable)",
    rows=[
        Row(
            panels=[
                Panel(
                    url=prestable_time_distribution_graph.get_dashboard_link(),
                    title="Response time distribution"
                ),
                Panel(
                    url=prestable_gateway_rps_api_graph.get_dashboard_link(),
                    title="API RPS"
                )
            ]
        ),
        Row(
            panels=[
                Panel(
                    url=prestable_uptime_graph.get_dashboard_link(),
                    title='Services Uptime'
                )
            ]
        ),
        Row(
            panels=[
                Panel(
                    url=prestable_sqs_message_count_graph.get_dashboard_link(),
                    title='SQS'
                )
            ]
        )
    ]
)

main_dashboard = Dashboard(
    id="agency_cabinet_main_dashboard",
    project_id=agency_cabinet_solomon_project.id,
    name="Agency Cabinet Services Dashboard",
    description="Основные метрики Агентского Кабинета",
    rows=[
        Row(
            panels=[
                Panel(
                    url=prod_time_distribution_graph.get_dashboard_link(),
                    title="Response time distribution"
                ),
                Panel(
                    url=prod_gateway_rps_api_graph.get_dashboard_link(),
                    title="API RPS"
                )
            ]
        ),
        Row(
            panels=[
                Panel(
                    url=prod_uptime_graph.get_dashboard_link(),
                    title='Services Uptime'
                )
            ]
        ),
        Row(
            panels=[
                Panel(
                    url=prod_sqs_message_count_graph.get_dashboard_link(),
                    title='SQS'
                )
            ]
        )
    ]
)


register = [
    main_dashboard_testing,
    main_dashboard_prestable,
    main_dashboard
]
