import crm.agency_cabinet.common.monitoring.clusters as clusters
from library.python.monitoring.solo.objects.solomon.v2 import Graph, Element, Cluster, Parameter
from crm.agency_cabinet.common.monitoring.project import agency_cabinet_solomon_project
from crm.agency_cabinet.common.monitoring.sensors.sqs import build_sqs_message_count_sensor


def build_service_sqs_message_count_graph(cluster: Cluster):
    sqs_sensor = build_sqs_message_count_sensor(cluster)
    return Graph(
        id=f"{cluster.name}_sqs_message_count_graph",
        project_id=agency_cabinet_solomon_project.id,
        parameters={
            Parameter(name="project", value=sqs_sensor.labels['project']),
            Parameter(name="cluster", value=sqs_sensor.labels['cluster']),
            Parameter(name="service", value=sqs_sensor.labels['service']),
        },
        name=f"SQS queues messages count ({cluster.name})",
        min="0",
        transform="NONE",
        hide_no_data=False,
        normalize=False,
        ignore_inf=False,
        stack=False,
        max_points=0,
        downsampling="BY_POINTS",
        scale="NATURAL",
        over_lines_transform="NONE",
        elements={
            Element(
                title="Queue messages count {{queue}}",
                type="EXPRESSION",
                expression=sqs_sensor.selectors,
                stack=None,
                area=False
            )
        }
    )


testing_sqs_message_count_graph = build_service_sqs_message_count_graph(clusters.testing)
prestable_sqs_message_count_graph = build_service_sqs_message_count_graph(clusters.prestable)
prod_sqs_message_count_graph = build_service_sqs_message_count_graph(clusters.prod)

register = [testing_sqs_message_count_graph, prestable_sqs_message_count_graph, prod_sqs_message_count_graph]
