import crm.agency_cabinet.common.monitoring.clusters as clusters
from crm.agency_cabinet.documents.monitoring.registry.service import documents
from crm.agency_cabinet.rewards.monitoring.registry.service import rewards
from crm.agency_cabinet.grants.monitoring.registry.service import grants
from crm.agency_cabinet.gateway.monitoring.registry.service import gateway
from crm.agency_cabinet.agencies.monitoring.registry.service import agencies
from library.python.monitoring.solo.objects.solomon.v2 import Graph, Element, Cluster, Selector, Service
from crm.agency_cabinet.rewards.monitoring.registry.sensors.metrics import REWARDS_UPTIME_METRIC
from crm.agency_cabinet.gateway.monitoring.registry.sensors.metrics import GATEWAY_UPTIME_METRIC
from crm.agency_cabinet.agencies.monitoring.registry.sensors.metrics import AGENCIES_UPTIME_METRIC
from crm.agency_cabinet.grants.monitoring.registry.sensors.metrics import GRANTS_UPTIME_METRIC
from crm.agency_cabinet.documents.monitoring.registry.sensors.metrics import DOCUMENTS_UPTIME_METRIC
from crm.agency_cabinet.common.monitoring.project import agency_cabinet_solomon_project


def build_uptime_graph_element(service: Service, cluster: Cluster) -> Element:
    if service == rewards:
        metrics_map = REWARDS_UPTIME_METRIC
    elif service == grants:
        metrics_map = GRANTS_UPTIME_METRIC
    elif service == gateway:
        metrics_map = GATEWAY_UPTIME_METRIC
    elif service == documents:
        metrics_map = DOCUMENTS_UPTIME_METRIC
    else:
        metrics_map = AGENCIES_UPTIME_METRIC

    return Element(
        title="{} Uptime {{{{host}}}}".format(service.name.capitalize()),
        selectors={
            Selector(
                name='sensor', value=metrics_map[cluster].name
            ),
            Selector(
                name='cluster', value=cluster.name,
            ),
            Selector(
                name='service', value=rewards.name
            ),
            Selector(
                name='documents', value=documents.name
            )
        },
        area=False
    )


def build_common_uptime_graph(cluster: Cluster):
    return Graph(
        id=f"{cluster.name}_common_uptime_graph",
        project_id=agency_cabinet_solomon_project.id,
        name=f"Services Uptime ({cluster.name})",
        min="0",
        transform="NONE",
        hide_no_data=False,
        normalize=False,
        ignore_inf=False,
        stack=False,
        max_points=0,
        downsampling="BY_POINTS",
        scale="NATURAL",
        over_lines_transform="NONE",
        elements={
            build_uptime_graph_element(agencies, cluster),
            build_uptime_graph_element(gateway, cluster),
            build_uptime_graph_element(rewards, cluster),
            build_uptime_graph_element(grants, cluster),
            build_uptime_graph_element(documents, cluster)
        }
    )


testing_uptime_graph = build_common_uptime_graph(clusters.testing)
prestable_uptime_graph = build_common_uptime_graph(clusters.prestable)
prod_uptime_graph = build_common_uptime_graph(clusters.prod)

register = [testing_uptime_graph, prestable_uptime_graph, prod_uptime_graph]
