from crm.agency_cabinet.common.enum import BaseEnum


class ReportStatuses(BaseEnum):
    all = 'all'
    draft = 'draft'
    sent = 'sent'


AD_DISTRIBUTOR_ID_YANDEX = 1


class ContractType(BaseEnum):
    contract = 'contract'
    intermediary_contract = 'intermediary_contract'
    additional_agreement = 'additional_agreement'


class ContractActionType(BaseEnum):
    other = 'other'  # Иное
    distribution = 'distribution'  # Действия в целях распространения рекламы
    conclude = 'conclude'  # Заключение договоров
    commercial = 'commercial'  # Коммерческое представительство


class ContractSubjectType(BaseEnum):
    representation = 'representation'  # Представительство
    other = 'other'  # Иное
    org_distribution = 'org_distribution'  # Договор на организацию распространения рекламы
    mediation = 'mediation'  # Посредничество
    distribution = 'distribution'  # Договор на распространение рекламы


class OrganizationType(BaseEnum):
    ffl = 'ffl'  # Иностранное физическое лицо
    ful = 'ful'  # Иностранное юридическое лицо
    ip = 'ip'  # Индивидуальный предприниматель
    fl = 'fl'  # Физическое лицо
    ul = 'ul'  # Юридическое лицо)


class ReporterType(BaseEnum):
    partner = 'partner'  # Партнер (агентство либо какой то субподрядчик)
    ad_distributor = 'ad_distributor'  # Площадка, в основном будет использоваться для Adfox
    advertiser = 'advertiser'  # Конечный рекламодатель


class InvitationStatus(BaseEnum):
    sent = 'sent'  # Приглашение отправлено
    accepted = 'accepted'  # Приглашение принято
    revoked = 'revoked'  # Приглашение отозвано
