import sys
import inspect


class OrdException(Exception):
    proto_field = 'error'

    def __init__(self, message=None):
        self.message = message


class NoSuchReportException(OrdException):

    proto_field = 'no_such_report'


class UnsuitableAgencyException(OrdException):

    proto_field = 'unsuitable_agency'


class NoSuchReportRowException(OrdException):

    proto_field = 'no_such_report_row'


class UniqueViolationReportRowException(OrdException):

    proto_field = 'unique_report_row_violation'


class ReportRowIsNotRemovableException(OrdException):

    proto_field = 'not_removable'


class ReportAlreadySentException(OrdException):

    proto_field = 'already_sent'


class ReportNotReadyException(OrdException):

    proto_field = 'report_not_ready'


class FileNotFoundException(OrdException):

    proto_field = 'file_not_found'


class ImportDataAlreadyRequested(OrdException):

    proto_field = 'import_already_requested'


class UniqueAdDistributorsActEidException(OrdException):

    proto_field = 'unique_ad_distributors_act_violation'


class NoSuchAdDistributorsActException(OrdException):

    proto_field = 'no_such_act'


class UnsuitableReportException(OrdException):

    proto_field = 'unsuitable_report'


class UnsupportedSettingException(OrdException):

    proto_field = 'unsupported_setting'


class UniqueViolationClientRowException(OrdException):

    proto_field = 'unique_client_row_violation'


class NoSuchClientRowException(OrdException):

    proto_field = 'no_such_client_row'


class UnsuitableClientException(OrdException):

    proto_field = 'unsuitable_client'


class NoSuchActException(OrdException):

    proto_field = 'no_such_act'


class UniqueViolationClientException(OrdException):
    proto_field = 'unique_client_violation'


class ForbiddenByReportSettingsException(OrdException):

    proto_field = 'forbidden_by_report_settings'


current_module = sys.modules[__name__]

ORD_EXCEPTIONS_LIST = inspect.getmembers(sys.modules[__name__], lambda cls: inspect.isclass(cls) and issubclass(cls, OrdException))


PROTO_FIELD_TO_EXCEPTION = {
    exception.proto_field: exception for name, exception in ORD_EXCEPTIONS_LIST
}  # TODO: check unique proto_field

__all__ = [name for name, exception in ORD_EXCEPTIONS_LIST] + ['PROTO_FIELD_TO_EXCEPTION']
