from marshmallow import Schema, fields, validate, EXCLUDE
from crm.agency_cabinet.ord.common.consts import OrganizationType


class Organization(Schema):
    type = fields.String(required=True)


class DomesticOrganization(Organization):
    class Meta:
        unknown = EXCLUDE
    inn = fields.String(required=True, allow_none=False)
    type = fields.String(required=True, validate=validate.OneOf(
        {OrganizationType.fl, OrganizationType.ul, OrganizationType.ip}
    ))


class ForeignOrganization(Organization):
    class Meta:
        unknown = EXCLUDE
    mobile_phone = fields.String(required=True, allow_none=False)
    type = fields.String(required=True, validate=validate.OneOf({OrganizationType.ffl, OrganizationType.ful}))
