from dataclasses import dataclass

from crm.agency_cabinet.common.proto_utils import BaseStruct
from crm.agency_cabinet.ord.proto import common_pb2


@dataclass
class ErrorMessageResponse(BaseStruct):
    message: str

    @classmethod
    def from_proto(cls, _message: common_pb2.ErrorMessageResponse) -> 'ErrorMessageResponse':
        return cls(message=_message.message)

    def to_proto(self) -> common_pb2.ErrorMessageResponse:
        return common_pb2.ErrorMessageResponse(message=self.message)
