import typing

from dataclasses import dataclass

from crm.agency_cabinet.common.server.common.structs import TaskStatuses, task_status_converter
from crm.agency_cabinet.common.proto_utils import BaseStruct
from crm.agency_cabinet.ord.proto import import_data_pb2


@dataclass
class ImportDataInput(BaseStruct):
    agency_id: int
    report_id: int
    filename: str
    bucket: str
    display_name: typing.Optional[str] = None

    @classmethod
    def from_proto(cls, message: import_data_pb2.ImportDataInput) -> 'ImportDataInput':
        return cls(
            agency_id=message.agency_id,
            report_id=message.report_id,
            filename=message.filename,
            bucket=message.bucket,
            display_name=message.display_name if message.HasField('display_name') else None
        )

    def to_proto(self) -> import_data_pb2.ImportDataInput:
        return import_data_pb2.ImportDataInput(
            agency_id=self.agency_id,
            report_id=self.report_id,
            filename=self.filename,
            bucket=self.bucket,
            display_name=self.display_name
        )


@dataclass
class TaskInfo(BaseStruct):
    task_id: int
    status: TaskStatuses

    @classmethod
    def from_proto(cls, message: import_data_pb2.TaskInfo) -> 'TaskInfo':
        return cls(
            task_id=message.task_id,
            status=task_status_converter.forward(message.status)
        )

    def to_proto(self) -> import_data_pb2.TaskInfo:
        return import_data_pb2.TaskInfo(
            task_id=self.task_id,
            status=task_status_converter.reversed(self.status)
        )


@dataclass
class GetLockStatusInput(BaseStruct):
    agency_id: int
    report_id: int

    @classmethod
    def from_proto(cls, message: import_data_pb2.GetLockStatusInput) -> 'GetLockStatusInput':
        return cls(
            agency_id=message.agency_id,
            report_id=message.report_id,
        )

    def to_proto(self) -> import_data_pb2.GetLockStatusInput:
        return import_data_pb2.GetLockStatusInput(
            agency_id=self.agency_id,
            report_id=self.report_id,
        )


@dataclass
class LockStatus(BaseStruct):
    lock: bool

    @classmethod
    def from_proto(cls, message: import_data_pb2.LockStatus) -> 'LockStatus':
        return cls(
            lock=message.lock
        )

    def to_proto(self) -> import_data_pb2.LockStatus:
        return import_data_pb2.LockStatus(
            lock=self.lock
        )
