import click

from crm.agency_cabinet.ord.server.src import run_server as _run_server
from crm.agency_cabinet.ord.server.src.celery import celery as celery_app


@click.group()
def cli():
    pass


@cli.command('run_server')
def run_server():
    return _run_server()


@cli.command('shell')
def shell():
    from IPython import embed
    embed()


def main():
    cli()


@cli.command('celery_beat', context_settings=dict(
    ignore_unknown_options=True,
))
@click.argument('celery_beat_args', nargs=-1, type=click.UNPROCESSED)
def celery_beat(celery_beat_args):
    return celery_app.start(['beat'] + list(celery_beat_args))


@cli.command(
    'celery_worker',
    context_settings=dict(
        ignore_unknown_options=True,
    ),
)
@click.argument('celery_worker_args', nargs=-1, type=click.UNPROCESSED)
def celery_worker(celery_worker_args):
    return celery_app.worker_main(argv=['worker'] + list(celery_worker_args))


if __name__ == '__main__':
    main()
