"""init

Revision ID: ae4e54f23037
Revises:
Create Date: 2022-01-14 10:54:18.635052+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv
import platform


# revision identifiers, used by Alembic.
revision = 'ae4e54f23037'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    if yenv.type != 'development' or platform.system() != 'Darwin':
        collation = 'C.UTF-8'
    else:
        collation = 'ru_RU.UTF-8'


    op.execute('CREATE SCHEMA IF NOT EXISTS ord')

    op.create_table('client',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('name', sa.Text(collation=collation), nullable=True),
                    sa.Column('agency_id', sa.BigInteger(), nullable=False),
                    sa.Column('login', sa.Text(), nullable=False),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.PrimaryKeyConstraint('id', name=op.f('client__pk')),
                    schema='ord'
                    )
    op.create_table('report',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('agency_id', sa.BigInteger(), nullable=False),
                    sa.Column('period_from', sa.DateTime(timezone=True), nullable=False),
                    sa.Column('status', sa.Text(), nullable=False),
                    sa.Column('sending_date', sa.DateTime(timezone=True), nullable=True),
                    sa.Column('ad_distributor_id', sa.BigInteger(), nullable=False),
                    sa.Column('contract_eid', sa.Text(collation=collation), nullable=False),
                    sa.Column('currency', sa.Text(), nullable=False, default='RUB'),
                    sa.Column('inn', sa.Text(), nullable=False),
                    sa.Column('vat', sa.BigInteger(), nullable=False, default=20),
                    sa.Column('is_deleted', sa.Boolean(), nullable=False, default=False),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.PrimaryKeyConstraint('id', name=op.f('report__pk')),
                    schema='ord'
                    )
    op.create_table('tools_yt_sync',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('path', sa.Text(), nullable=True),
                    sa.Column('tag', sa.Text(), nullable=True),
                    sa.Column('last_used_update', sa.DateTime(timezone=True), nullable=True),
                    sa.Column('enabled', sa.Boolean(), server_default='t', nullable=True),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.PrimaryKeyConstraint('id', name=op.f('tools_yt_sync__pk')),
                    schema='ord'
                    )
    op.create_index('tools_yt_sync__path_tag__idx', 'tools_yt_sync', ['path', 'tag'], unique=True, schema='ord')
    op.create_table('report_row',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('report_id', sa.BigInteger(), nullable=False),
                    sa.Column('client_id', sa.BigInteger(), nullable=False),
                    sa.Column('contract_eid', sa.Text(collation=collation), nullable=True),
                    sa.Column('inn', sa.Text(), nullable=True),
                    sa.Column('act_eid', sa.Text(collation=collation), nullable=True),
                    sa.Column('amount', sa.Numeric(precision=18, scale=6), nullable=True),
                    sa.Column('suggested_amount', sa.Numeric(precision=18, scale=6), nullable=True),
                    sa.Column('is_yt', sa.Boolean(), nullable=False),
                    sa.Column('is_valid', sa.Boolean(), nullable=False, default=False),
                    sa.Column('vat', sa.BigInteger(), nullable=False, default=20),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
                    sa.ForeignKeyConstraint(['client_id'], ['ord.client.id'], name=op.f('report_row_client__client_id__fk')),
                    sa.ForeignKeyConstraint(['report_id'], ['ord.report.id'], name=op.f('report_row_report__report_id__fk')),
                    sa.PrimaryKeyConstraint('id', name=op.f('report_row__pk')),
                    schema='ord'
                    )
    op.create_index('report_row__report_id_client_id_inn_act_eid__idx', 'report_row', ['report_id', 'client_id', 'inn', 'act_eid'], unique=True, schema='ord')
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('report_row__report_id_client_id_inn_act_eid__idx', table_name='report_row', schema='ord')
    op.drop_table('report_row', schema='ord')
    op.drop_index('tools_yt_sync__path_tag__idx', table_name='tools_yt_sync', schema='ord')
    op.drop_table('tools_yt_sync', schema='ord')
    op.drop_index('report__agency_id_period_from_status__idx', table_name='report', schema='ord')
    op.drop_table('report', schema='ord')
    op.drop_table('client', schema='ord')

    op.execute('DROP SCHEMA ord')
    # ### end Alembic commands ###
