"""empty message

Revision ID: 0bf09df4358a
Revises: ae4e54f23037
Create Date: 2022-02-02 11:12:54.908714+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv
import platform



# revision identifiers, used by Alembic.
revision = '0bf09df4358a'
down_revision = 'ae4e54f23037'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    if yenv.type != 'development' or platform.system() != 'Darwin':
        collation = 'C.UTF-8'
    else:
        collation = 'ru_RU.UTF-8'

    op.create_table('s3_mds_file',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('bucket', sa.Text(), nullable=False),
    sa.Column('name', sa.Text(), nullable=False),
    sa.Column('display_name', sa.Text(collation=collation), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('s3_mds_file__pk')),
    schema='ord'
    )
    op.create_table('report_export_info',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('report_id', sa.BigInteger(), nullable=False),
    sa.Column('file_id', sa.BigInteger(), nullable=True),
    sa.Column('status', sa.Text(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.ForeignKeyConstraint(['file_id'], ['ord.s3_mds_file.id'], name=op.f('report_export_info_s3_mds_file__file_id__fk'), ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['report_id'], ['ord.report.id'], name=op.f('report_export_info_report__report_id__fk'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name=op.f('report_export_info__pk')),
    schema='ord'
    )
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('report_export_info', schema='ord')
    op.drop_table('s3_mds_file', schema='ord')
    # ### end Alembic commands ###
