"""empty message

Revision ID: 96ad42be4969
Revises: 0bf09df4358a
Create Date: 2022-02-10 08:34:13.510526+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv



# revision identifiers, used by Alembic.
revision = '96ad42be4969'
down_revision = '0bf09df4358a'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('report_import_info',
        sa.Column('id', sa.BigInteger(), nullable=False),
        sa.Column('report_id', sa.BigInteger(), nullable=False),
        sa.Column('file_id', sa.BigInteger(), nullable=True),
        sa.Column('status', sa.Text(), nullable=False),
        sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
        sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
        sa.ForeignKeyConstraint(['file_id'], ['ord.s3_mds_file.id'], name=op.f('report_import_info_s3_mds_file__file_id__fk'), ondelete='CASCADE'),
        sa.ForeignKeyConstraint(['report_id'], ['ord.report.id'], name=op.f('report_import_info_report__report_id__fk'), ondelete='CASCADE'),
        sa.PrimaryKeyConstraint('id', name=op.f('report_import_info__pk')),
        schema='ord'
    )

    op.create_index('report_import_info__report_id_status__idx', 'report_import_info', ['report_id', 'status'], unique=True, schema='ord', postgresql_where=sa.text("status IN ('requested', 'in_progress')"))
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('report_import_info__report_id_status__idx', table_name='report_import_info', schema='ord')
    op.drop_table('report_import_info', schema='ord')
    # ### end Alembic commands ###
