"""empty message

Revision ID: 2bcd4f7dbdcb
Revises: 96ad42be4969
Create Date: 2022-04-04 11:52:41.733240+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv
import platform



# revision identifiers, used by Alembic.
revision = '2bcd4f7dbdcb'
down_revision = '96ad42be4969'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    if yenv.type != 'development' or platform.system() != 'Darwin':
        collation = 'C.UTF-8'
    else:
        collation = 'ru_RU.UTF-8'

    op.create_table('ad_distributor',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('name', sa.Text(), nullable=False),
                    sa.Column('display_name', sa.Text(collation=collation), nullable=False),
                    sa.Column('inn', sa.Text(), nullable=False),
                    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'),
                              nullable=False),
                    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'),
                              nullable=False),
                    sa.PrimaryKeyConstraint('id', name=op.f('ad_distributor__pk')),
                    schema='ord'
                    )
    op.create_foreign_key(op.f('report_ad_distributor_id__fk'), 'report', 'ad_distributor',
                          ['ad_distributor_id'], ['id'], source_schema='ord', referent_schema='ord')
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('ad_distributor', schema='ord')
    # ### end Alembic commands ###
