"""ad_distributor_acts

Revision ID: 5440e39b0d0f
Revises: 2bcd4f7dbdcb
Create Date: 2022-04-06 11:46:40.088228+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv



# revision identifiers, used by Alembic.
revision = '5440e39b0d0f'
down_revision = '2bcd4f7dbdcb'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('ad_distributor_act',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('act_eid', sa.Text(), nullable=True),
    sa.Column('amount', sa.Numeric(precision=18, scale=6), nullable=True),
    sa.Column('file_id', sa.BigInteger(), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.ForeignKeyConstraint(['file_id'], ['ord.s3_mds_file.id'], name=op.f('ad_distributor_act_s3_mds_file__file_id__fk'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name=op.f('ad_distributor_act__pk')),
    schema='ord'
    )
    op.add_column('report_row', sa.Column('ad_distributor_act_id', sa.BigInteger(), nullable=True), schema='ord')
    op.create_foreign_key(op.f('report_row_ad_distributor_act__ad_distributor_act_id__fk'), 'report_row', 'ad_distributor_act', ['ad_distributor_act_id'], ['id'], source_schema='ord', referent_schema='ord')
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f('report_row_ad_distributor_act__ad_distributor_act_id__fk'), 'report_row', schema='ord', type_='foreignkey')
    op.drop_column('report_row', 'ad_distributor_act_id', schema='ord')
    op.drop_table('ad_distributor_act', schema='ord')
    # ### end Alembic commands ###
