"""report_ad_distributor_act_map

Revision ID: db636958fd18
Revises: c79b3ead2a30
Create Date: 2022-04-12 09:43:53.305545+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv



# revision identifiers, used by Alembic.
revision = 'db636958fd18'
down_revision = 'c79b3ead2a30'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('report_row_ad_distributor_act_map',
    sa.Column('ad_distributor_act_id', sa.BigInteger(), nullable=False),
    sa.Column('report_row_id', sa.BigInteger(), nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.ForeignKeyConstraint(['ad_distributor_act_id'], ['ord.ad_distributor_act.id'], name=op.f('report_row_ad_distributor_act_map_ad_distributor_act__ad_distributor_act_id__fk')),
    sa.ForeignKeyConstraint(['report_row_id'], ['ord.report_row.id'], name=op.f('report_row_ad_distributor_act_map_report_row__report_row_id__fk')),
    sa.PrimaryKeyConstraint('report_row_id', 'ad_distributor_act_id', name=op.f('report_row_ad_distributor_act_map__pk')),
    schema='ord'
    )
    op.drop_constraint('report_row_ad_distributor_act__ad_distributor_act_id__fk', 'report_row', schema='ord', type_='foreignkey')
    op.drop_column('report_row', 'ad_distributor_act_id', schema='ord')
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('report_row', sa.Column('ad_distributor_act_id', sa.BIGINT(), autoincrement=False, nullable=True), schema='ord')
    op.create_foreign_key('report_row_ad_distributor_act__ad_distributor_act_id__fk', 'report_row', 'ad_distributor_act', ['ad_distributor_act_id'], ['id'], source_schema='ord', referent_schema='ord')
    op.drop_table('report_row_ad_distributor_act_map', schema='ord')
    # ### end Alembic commands ###
