"""ad_distributors_act_report_id

Revision ID: cc604e69eac8
Revises: db636958fd18
Create Date: 2022-04-14 11:08:40.015899+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv



# revision identifiers, used by Alembic.
revision = 'cc604e69eac8'
down_revision = 'db636958fd18'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('ad_distributor_act', sa.Column('report_id', sa.BigInteger(), nullable=True), schema='ord')
    op.drop_constraint('ad_distributor_act__act_eid__uq', 'ad_distributor_act', schema='ord', type_='unique')
    op.create_unique_constraint(op.f('ad_distributor_act__report_id__uq'), 'ad_distributor_act', ['report_id', 'act_eid'], schema='ord')
    op.create_foreign_key(op.f('ad_distributor_act_report__report_id__fk'), 'ad_distributor_act', 'report', ['report_id'], ['id'], source_schema='ord', referent_schema='ord')
    op.drop_column('ad_distributor_act', 'agency_id', schema='ord')
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('ad_distributor_act', sa.Column('agency_id', sa.BIGINT(), autoincrement=False, nullable=True), schema='ord')
    op.drop_constraint(op.f('ad_distributor_act_report__report_id__fk'), 'ad_distributor_act', schema='ord', type_='foreignkey')
    op.drop_constraint(op.f('ad_distributor_act__report_id__uq'), 'ad_distributor_act', schema='ord', type_='unique')
    op.create_unique_constraint('ad_distributor_act__act_eid__uq', 'ad_distributor_act', ['act_eid'], schema='ord')
    op.drop_column('ad_distributor_act', 'report_id', schema='ord')
    # ### end Alembic commands ###
