"""empty message

Revision ID: 7a84cc0cf16f
Revises: cc604e69eac8
Create Date: 2022-04-21 14:11:37.127519+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv



# revision identifiers, used by Alembic.
revision = '7a84cc0cf16f'
down_revision = 'cc604e69eac8'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('client', sa.Column('client_id', sa.Text(), nullable=True), schema='ord')
    op.add_column('client', sa.Column('report_id', sa.BigInteger(), nullable=True), schema='ord')
    op.add_column('client', sa.Column('is_yt', sa.Boolean(), nullable=False, server_default='t'), schema='ord')
    op.alter_column('client', 'login',
               existing_type=sa.TEXT(),
               nullable=True,
               schema='ord')
    op.alter_column('client', 'agency_id',
               existing_type=sa.BigInteger(),
               nullable=True,
               schema='ord')
    op.create_index('client__report_id_client_id__idx', 'client', ['report_id', 'client_id'], unique=True, schema='ord')
    op.create_foreign_key(op.f('client_report__report_id__fk'), 'client', 'report', ['report_id'], ['id'], source_schema='ord', referent_schema='ord')
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f('client_report__report_id__fk'), 'client', schema='ord', type_='foreignkey')
    op.drop_index('client__report_id_client_id__idx', table_name='client', schema='ord')
    op.alter_column('client', 'agency_id',
               existing_type=sa.BigInteger(),
               nullable=False,
               schema='ord')
    op.alter_column('client', 'login',
               existing_type=sa.TEXT(),
               nullable=False,
               schema='ord')
    op.drop_column('client', 'is_yt', schema='ord')
    op.drop_column('client', 'report_id', schema='ord')
    op.drop_column('client', 'client_id', schema='ord')
    # ### end Alembic commands ###
