"""client_row, campaign, client_act

Revision ID: aef6462d1dfb
Revises: 79d8d14b8b4d
Create Date: 2022-06-08 14:25:23.557833+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv
import platform


# revision identifiers, used by Alembic.
revision = 'aef6462d1dfb'
down_revision = 'ca0d0af22239'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    if yenv.type != 'development' or platform.system() != 'Darwin':
        collation = 'C.UTF-8'
    else:
        collation = 'ru_RU.UTF-8'

    op.create_table('campaign',
        sa.Column('id', sa.BigInteger(), nullable=False),
        sa.Column('report_id', sa.BigInteger(), nullable=False),
        sa.Column('campaign_eid', sa.Text(collation=collation), nullable=False),
        sa.Column('name', sa.Text(collation=collation), nullable=True),
        sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
        sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
        sa.ForeignKeyConstraint(['report_id'], ['ord.report.id'], name=op.f('campaign_report__report_id__fk')),
        sa.PrimaryKeyConstraint('id', name=op.f('campaign__pk')),
        sa.UniqueConstraint('report_id', 'campaign_eid', name=op.f('campaign__report_id__uq')),
        schema='ord'
    )
    op.create_table('client_act',
        sa.Column('id', sa.BigInteger(), nullable=False),
        sa.Column('report_id', sa.BigInteger(), nullable=False),
        sa.Column('contract_eid', sa.Text(collation=collation), nullable=True),
        sa.Column('inn', sa.Text(), nullable=True),
        sa.Column('act_eid', sa.Text(collation=collation), nullable=False),
        sa.Column('amount', sa.Numeric(precision=18, scale=6), nullable=True),
        sa.Column('vat', sa.BigInteger(), nullable=True),
        sa.Column('currency', sa.Text(), nullable=True),
        sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
        sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
        sa.ForeignKeyConstraint(['report_id'], ['ord.report.id'], name=op.f('client_act_report__report_id__fk')),
        sa.PrimaryKeyConstraint('id', name=op.f('client_act__pk')),
        sa.UniqueConstraint('report_id', 'act_eid', name=op.f('client_act__report_id__uq')),
        schema='ord'
    )
    op.create_table('client_row',
        sa.Column('id', sa.BigInteger(), nullable=False),
        sa.Column('client_id', sa.BigInteger(), nullable=False),
        sa.Column('client_act_id', sa.BigInteger(), nullable=True),
        sa.Column('campaign_id', sa.BigInteger(), nullable=True),
        sa.Column('ad_distributor_act_id', sa.BigInteger(), nullable=False),
        sa.Column('suggested_amount', sa.Numeric(precision=18, scale=6), nullable=True),
        sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
        sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
        sa.ForeignKeyConstraint(['ad_distributor_act_id'], ['ord.ad_distributor_act.id'], name=op.f('client_row_ad_distributor_act__ad_distributor_act_id__fk')),
        sa.ForeignKeyConstraint(['campaign_id'], ['ord.campaign.id'], name=op.f('client_row_campaign__campaign_id__fk')),
        sa.ForeignKeyConstraint(['client_act_id'], ['ord.client_act.id'], name=op.f('client_row_client_act__client_act_id__fk')),
        sa.ForeignKeyConstraint(['client_id'], ['ord.client.id'], name=op.f('client_row_client__client_id__fk')),
        sa.PrimaryKeyConstraint('id', name=op.f('client_row__pk')),
        schema='ord'
    )
    op.create_index('client_row__client_ad_distr_act_campaign_client_act__idx', 'client_row', ['client_id', 'ad_distributor_act_id', 'campaign_id', 'client_act_id'], unique=True, schema='ord')
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('client_row__client_ad_distr_act_campaign_client_act__idx', table_name='client_row', schema='ord')
    op.drop_table('client_row', schema='ord')
    op.drop_table('client_act', schema='ord')
    op.drop_table('campaign', schema='ord')
    # ### end Alembic commands ###
