"""empty message

Revision ID: a61103bedfa5
Revises: aef6462d1dfb
Create Date: 2022-06-22 10:49:01.361522+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv
import platform

# revision identifiers, used by Alembic.
revision = 'a61103bedfa5'
down_revision = 'aef6462d1dfb'
branch_labels = None
depends_on = None

if yenv.type != 'development' or platform.system() != 'Darwin':
    collation = 'C.UTF-8'
else:
    collation = 'ru_RU.UTF-8'

def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('legal_entity',
        sa.Column('id', sa.BigInteger(), nullable=False),
        sa.Column('contract_eid', sa.Text(collation=collation), nullable=True),
        sa.Column('inn', sa.Text(collation=collation), nullable=True),
        sa.Column('vat', sa.BigInteger(), nullable=True),
        sa.Column('currency', sa.Text(), nullable=True),
        sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
        sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
        sa.PrimaryKeyConstraint('id', name=op.f('legal_entity__pk')),
        schema='ord'
    )
    op.create_table('client_legal_entity_map',
        sa.Column('client_id', sa.BigInteger(), nullable=False),
        sa.Column('legal_entity_id', sa.BigInteger(), nullable=False),
        sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
        sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
        sa.ForeignKeyConstraint(['client_id'], ['ord.client.id'], name=op.f('client_legal_entity_map_client__client_id__fk')),
        sa.ForeignKeyConstraint(['legal_entity_id'], ['ord.legal_entity.id'], name=op.f('client_legal_entity_map_legal_entity__legal_entity_id__fk')),
        sa.PrimaryKeyConstraint('client_id', 'legal_entity_id', name=op.f('client_legal_entity_map__pk')),
        schema='ord'
    )
    op.add_column('client_act', sa.Column('legal_entity_id', sa.BigInteger(), nullable=True), schema='ord')
    op.create_foreign_key(op.f('client_act_legal_entity__legal_entity_id__fk'), 'client_act', 'legal_entity', ['legal_entity_id'], ['id'], source_schema='ord', referent_schema='ord')
    op.drop_column('client_act', 'contract_eid', schema='ord')
    op.drop_column('client_act', 'currency', schema='ord')
    op.drop_column('client_act', 'vat', schema='ord')
    op.drop_column('client_act', 'inn', schema='ord')
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('client_act', sa.Column('inn', sa.TEXT(collation=collation), autoincrement=False, nullable=True), schema='ord')
    op.add_column('client_act', sa.Column('vat', sa.BIGINT(), autoincrement=False, nullable=True), schema='ord')
    op.add_column('client_act', sa.Column('currency', sa.TEXT(), autoincrement=False, nullable=True), schema='ord')
    op.add_column('client_act', sa.Column('contract_eid', sa.TEXT(collation=collation), autoincrement=False, nullable=True), schema='ord')
    op.drop_constraint(op.f('client_act_legal_entity__legal_entity_id__fk'), 'client_act', schema='ord', type_='foreignkey')
    op.drop_column('client_act', 'legal_entity_id', schema='ord')
    op.drop_table('client_legal_entity_map', schema='ord')
    op.drop_table('legal_entity', schema='ord')
    # ### end Alembic commands ###
