"""campaigns

Revision ID: f55e6a1d428b
Revises: a61103bedfa5
Create Date: 2022-06-23 11:54:37.229996+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv

from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = 'f55e6a1d428b'
down_revision = 'a61103bedfa5'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('campaign', sa.Column('client_id', sa.BigInteger(), nullable=False), schema='ord')
    op.create_unique_constraint(op.f('campaign__client_id__uq'), 'campaign', ['client_id', 'campaign_eid'], schema='ord')
    op.create_foreign_key(op.f('campaign_client__client_id__fk'), 'campaign', 'client', ['client_id'], ['id'], source_schema='ord', referent_schema='ord')
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f('campaign_client__client_id__fk'), 'campaign', schema='ord', type_='foreignkey')
    op.drop_constraint(op.f('campaign__client_id__uq'), 'campaign', schema='ord', type_='unique')
    op.drop_column('campaign', 'client_id', schema='ord')
    # ### end Alembic commands ###
