"""ord_contracts

Revision ID: d1ea2fced694
Revises: a61103bedfa5
Create Date: 2022-06-27 18:17:00.046392+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv



# revision identifiers, used by Alembic.
revision = 'd1ea2fced694'
down_revision = 'f55e6a1d428b'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('client_contract',
        sa.Column('id', sa.BigInteger(), nullable=False),
        sa.Column('legal_entity_id', sa.BigInteger(), nullable=True),
        sa.Column('file_id', sa.BigInteger(), nullable=True),
        sa.Column('contract_eid', sa.Text(), nullable=True),
        sa.Column('vat', sa.BigInteger(), nullable=True),
        sa.Column('currency', sa.Text(), nullable=True),
        sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
        sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
        sa.ForeignKeyConstraint(['file_id'], ['ord.s3_mds_file.id'], name=op.f('client_contract_s3_mds_file__file_id__fk')),
        sa.ForeignKeyConstraint(['legal_entity_id'], ['ord.legal_entity.id'], name=op.f('client_contract_legal_entity__legal_entity_id__fk')),
        sa.PrimaryKeyConstraint('id', name=op.f('client_contract__pk')),
        sa.UniqueConstraint('legal_entity_id', 'contract_eid', name=op.f('client_contract__legal_entity_id__uq')),
        schema='ord'
    )
    op.drop_constraint('ad_distributor_act_s3_mds_file__file_id__fk', 'ad_distributor_act', schema='ord', type_='foreignkey')
    op.create_foreign_key(op.f('ad_distributor_act_s3_mds_file__file_id__fk'), 'ad_distributor_act', 's3_mds_file', ['file_id'], ['id'], source_schema='ord', referent_schema='ord')
    op.add_column('client_act', sa.Column('file_id', sa.BigInteger(), nullable=True), schema='ord')
    op.create_foreign_key(op.f('client_act_s3_mds_file__file_id__fk'), 'client_act', 's3_mds_file', ['file_id'], ['id'], source_schema='ord', referent_schema='ord')
    op.add_column('client_row', sa.Column('client_contract_id', sa.BigInteger(), nullable=True), schema='ord')
    op.create_foreign_key(op.f('client_row_client_contract__client_contract_id__fk'), 'client_row', 'client_contract', ['client_contract_id'], ['id'], source_schema='ord', referent_schema='ord')
    op.add_column('legal_entity', sa.Column('agency_id', sa.BigInteger(), nullable=True), schema='ord')
    op.add_column('legal_entity', sa.Column('name', sa.Text(), nullable=True), schema='ord')
    op.alter_column('legal_entity', 'contract_eid', existing_type=sa.TEXT(), nullable=True, schema='ord')
    op.drop_constraint('report_export_info_s3_mds_file__file_id__fk', 'report_export_info', schema='ord', type_='foreignkey')
    op.create_foreign_key(op.f('report_export_info_s3_mds_file__file_id__fk'), 'report_export_info', 's3_mds_file', ['file_id'], ['id'], source_schema='ord', referent_schema='ord')
    op.drop_constraint('report_import_info_s3_mds_file__file_id__fk', 'report_import_info', schema='ord', type_='foreignkey')
    op.create_foreign_key(op.f('report_import_info_s3_mds_file__file_id__fk'), 'report_import_info', 's3_mds_file', ['file_id'], ['id'], source_schema='ord', referent_schema='ord')
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f('report_import_info_s3_mds_file__file_id__fk'), 'report_import_info', schema='ord', type_='foreignkey')
    op.create_foreign_key('report_import_info_s3_mds_file__file_id__fk', 'report_import_info', 's3_mds_file', ['file_id'], ['id'], source_schema='ord', referent_schema='ord', ondelete='CASCADE')
    op.drop_constraint(op.f('report_export_info_s3_mds_file__file_id__fk'), 'report_export_info', schema='ord', type_='foreignkey')
    op.create_foreign_key('report_export_info_s3_mds_file__file_id__fk', 'report_export_info', 's3_mds_file', ['file_id'], ['id'], source_schema='ord', referent_schema='ord', ondelete='CASCADE')
    op.alter_column('legal_entity', 'contract_eid', existing_type=sa.TEXT(), nullable=False, schema='ord')
    op.drop_column('legal_entity', 'name', schema='ord')
    op.drop_column('legal_entity', 'agency_id', schema='ord')
    op.drop_constraint(op.f('client_row_client_contract__client_contract_id__fk'), 'client_row', schema='ord', type_='foreignkey')
    op.drop_column('client_row', 'client_contract_id', schema='ord')
    op.drop_constraint(op.f('client_act_s3_mds_file__file_id__fk'), 'client_act', schema='ord', type_='foreignkey')
    op.drop_column('client_act', 'file_id', schema='ord')
    op.drop_constraint(op.f('ad_distributor_act_s3_mds_file__file_id__fk'), 'ad_distributor_act', schema='ord', type_='foreignkey')
    op.create_foreign_key('ad_distributor_act_s3_mds_file__file_id__fk', 'ad_distributor_act', 's3_mds_file', ['file_id'], ['id'], source_schema='ord', referent_schema='ord', ondelete='CASCADE')
    op.drop_table('client_contract', schema='ord')
    # ### end Alembic commands ###
