"""contract, act, organization

Revision ID: 2bf91fa670b0
Revises: d1ea2fced694
Create Date: 2022-07-07 21:28:33.879835+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv

from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '2bf91fa670b0'
down_revision = 'd1ea2fced694'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('organization',
        sa.Column('id', sa.BigInteger(), nullable=False),
        sa.Column('partner_id', sa.BigInteger(), nullable=True),
        sa.Column('type', sa.Text(), nullable=True),
        sa.Column('inn', sa.Text(), nullable=True),
        sa.Column('name', sa.Text(), nullable=True),
        sa.Column('is_rr', sa.Boolean(), nullable=True),
        sa.Column('is_ors', sa.Boolean(), nullable=True),
        sa.Column('mobile_phone', sa.Text(), nullable=True),
        sa.Column('epay_number', sa.Text(), nullable=True),
        sa.Column('reg_number', sa.Text(), nullable=True),
        sa.Column('alter_inn', sa.Text(), nullable=True),
        sa.Column('oksm_number', sa.Text(), nullable=True),
        sa.Column('rs_url', sa.Text(), nullable=True),
        sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
        sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
        sa.CheckConstraint("type in ('ffl', 'ful', 'ip', 'fl', 'ul')", name=op.f('organization__validate_organization_type__ck')),
        sa.PrimaryKeyConstraint('id', name=op.f('organization__pk')),
        schema='ord'
    )
    op.create_table('contract',
        sa.Column('id', sa.BigInteger(), nullable=False),
        sa.Column('client_id', sa.BigInteger(), nullable=True),
        sa.Column('contractor_id', sa.BigInteger(), nullable=True),
        sa.Column('contract_eid', sa.Text(), nullable=True),
        sa.Column('is_reg_report', sa.Boolean(), nullable=True),
        sa.Column('type', sa.Text(), nullable=True),
        sa.Column('action_type', sa.Text(), nullable=True),
        sa.Column('subject_type', sa.Text(), nullable=True),
        sa.Column('date', sa.DateTime(timezone=True), nullable=True),
        sa.Column('amount', sa.Numeric(precision=18, scale=6), nullable=True),
        sa.Column('is_vat', sa.Boolean(), nullable=True),
        sa.Column('original_contract_eid', sa.Text(), nullable=True),
        sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
        sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
        sa.CheckConstraint("action_type in ('other', 'distribution', 'conclude', 'commercial')", name=op.f('contract__validate_action_type__ck')),
        sa.CheckConstraint("subject_type in ('representation', 'other', 'org_distribution', 'mediation', 'distribution')", name=op.f('contract__validate_subject_type__ck')),
        sa.CheckConstraint("type in ('contract', 'intermediary_contract', 'additional_agreement')", name=op.f('contract__validate_contract_type__ck')),
        sa.ForeignKeyConstraint(['client_id'], ['ord.organization.id'], name=op.f('contract_organization__client_id__fk')),
        sa.ForeignKeyConstraint(['contractor_id'], ['ord.organization.id'], name=op.f('contract_organization__contractor_id__fk')),
        sa.PrimaryKeyConstraint('id', name=op.f('contract__pk')),
        sa.UniqueConstraint('contract_eid', 'client_id', 'contractor_id', name=op.f('contract__contract_eid__uq')),
        schema='ord'
    )
    op.create_table('act',
        sa.Column('id', sa.BigInteger(), nullable=False),
        sa.Column('report_id', sa.BigInteger(), nullable=False),
        sa.Column('act_eid', sa.Text(), nullable=True),
        sa.Column('amount', sa.Numeric(precision=18, scale=6), nullable=True),
        sa.Column('is_vat', sa.Boolean(), nullable=True),
        sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
        sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
        sa.ForeignKeyConstraint(['report_id'], ['ord.report.id'], name=op.f('act_report__report_id__fk')),
        sa.PrimaryKeyConstraint('id', name=op.f('act__pk')),
        sa.UniqueConstraint('report_id', 'act_eid', name=op.f('act__report_id__uq')),
        schema='ord'
    )
    op.add_column('client_row', sa.Column('ad_distributor_contract_id', sa.BigInteger(), nullable=True), schema='ord')
    op.add_column('client_row', sa.Column('partner_contract_id', sa.BigInteger(), nullable=True), schema='ord')
    op.add_column('client_row', sa.Column('advertiser_contract_id', sa.BigInteger(), nullable=True), schema='ord')
    op.add_column('client_row', sa.Column('partner_act_id', sa.BigInteger(), nullable=True), schema='ord')
    op.alter_column('client_row', 'ad_distributor_act_id',
               existing_type=sa.BIGINT(),
               nullable=True,
               schema='ord')
    op.drop_constraint('client_row_ad_distributor_act__ad_distributor_act_id__fk', 'client_row', schema='ord', type_='foreignkey')
    op.create_foreign_key(op.f('client_row_act__ad_distributor_act_id__fk'), 'client_row', 'act', ['ad_distributor_act_id'], ['id'], source_schema='ord', referent_schema='ord')
    op.create_foreign_key(op.f('client_row_contract__ad_distributor_contract_id__fk'), 'client_row', 'contract', ['ad_distributor_contract_id'], ['id'], source_schema='ord', referent_schema='ord')
    op.create_foreign_key(op.f('client_row_act__partner_act_id__fk'), 'client_row', 'act', ['partner_act_id'], ['id'], source_schema='ord', referent_schema='ord')
    op.create_foreign_key(op.f('client_row_contract__advertiser_contract_id__fk'), 'client_row', 'contract', ['advertiser_contract_id'], ['id'], source_schema='ord', referent_schema='ord')
    op.create_foreign_key(op.f('client_row_contract__partner_contract_id__fk'), 'client_row', 'contract', ['partner_contract_id'], ['id'], source_schema='ord', referent_schema='ord')
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(op.f('client_row_contract__partner_contract_id__fk'), 'client_row', schema='ord', type_='foreignkey')
    op.drop_constraint(op.f('client_row_contract__advertiser_contract_id__fk'), 'client_row', schema='ord', type_='foreignkey')
    op.drop_constraint(op.f('client_row_act__partner_act_id__fk'), 'client_row', schema='ord', type_='foreignkey')
    op.drop_constraint(op.f('client_row_contract__ad_distributor_contract_id__fk'), 'client_row', schema='ord', type_='foreignkey')
    op.drop_constraint(op.f('client_row_act__ad_distributor_act_id__fk'), 'client_row', schema='ord', type_='foreignkey')
    op.create_foreign_key('client_row_ad_distributor_act__ad_distributor_act_id__fk', 'client_row', 'ad_distributor_act', ['ad_distributor_act_id'], ['id'], source_schema='ord', referent_schema='ord')
    op.alter_column('client_row', 'ad_distributor_act_id',
               existing_type=sa.BIGINT(),
               nullable=False,
               schema='ord')
    op.drop_column('client_row', 'partner_act_id', schema='ord')
    op.drop_column('client_row', 'advertiser_contract_id', schema='ord')
    op.drop_column('client_row', 'partner_contract_id', schema='ord')
    op.drop_column('client_row', 'ad_distributor_contract_id', schema='ord')
    op.alter_column('client_act', 'legal_entity_id',
               existing_type=sa.BIGINT(),
               nullable=False,
               schema='ord')
    op.drop_table('act', schema='ord')
    op.drop_table('contract', schema='ord')
    op.drop_table('organization', schema='ord')
    # ### end Alembic commands ###
