"""report_and_settings

Revision ID: c3071f877705
Revises: 2bf91fa670b0
Create Date: 2022-07-10 13:42:33.174797+00:00

"""
from alembic import op
import sqlalchemy as sa
import yenv

from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = 'c3071f877705'
down_revision = '2bf91fa670b0'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('report_settings',
        sa.Column('id', sa.BigInteger(), nullable=False),
        sa.Column('name', sa.Text(), nullable=False),
        sa.Column('display_name', sa.Text(), nullable=False),
        sa.Column('settings', postgresql.JSONB(astext_type=sa.Text()), server_default='{}', nullable=False),
        sa.Column('created_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
        sa.Column('updated_at', sa.DateTime(timezone=True), server_default=sa.text('now()'), nullable=False),
        sa.PrimaryKeyConstraint('id', name=op.f('report_settings__pk')),
        sa.UniqueConstraint('name', name=op.f('report_settings__name__uq')),
        schema='ord'
    )
    op.drop_constraint('report_ad_distributor_id__fk', 'report', schema='ord', type_='foreignkey')
    op.drop_table('ad_distributor', schema='ord')
    op.add_column('report', sa.Column('settings_id', sa.BigInteger(), nullable=False), schema='ord')
    op.add_column('report', sa.Column('reporter_type', sa.Text(), nullable=False), schema='ord')
    op.create_foreign_key(op.f('report_report_settings__settings_id__fk'), 'report', 'report_settings', ['settings_id'], ['id'], source_schema='ord', referent_schema='ord')
    op.drop_column('report', 'currency', schema='ord')
    op.drop_column('report', 'ad_distributor_id', schema='ord')
    op.drop_column('report', 'agency_inn', schema='ord')
    op.drop_column('report', 'contract_eid', schema='ord')
    op.drop_column('report', 'vat', schema='ord')

    op.execute("""
            INSERT INTO ord.report_settings("name", display_name)
            VALUES
            ('other', 'Другое'),
            ('direct', 'Директ'),
            ('adfox', 'Adfox');
        """)
    # ### end Alembic commands ###


def downgrade():
    if yenv.type not in ['testing', 'development']:
        raise Exception('Downgrade forbidden')

    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('report', sa.Column('vat', sa.BIGINT(), autoincrement=False, nullable=False), schema='ord')
    op.add_column('report', sa.Column('contract_eid', sa.TEXT(), autoincrement=False, nullable=False), schema='ord')
    op.add_column('report', sa.Column('agency_inn', sa.TEXT(), autoincrement=False, nullable=True), schema='ord')
    op.add_column('report', sa.Column('ad_distributor_id', sa.BIGINT(), autoincrement=False, nullable=False), schema='ord')
    op.add_column('report', sa.Column('currency', sa.TEXT(), autoincrement=False, nullable=False), schema='ord')
    op.drop_constraint(op.f('report_report_settings__settings_id__fk'), 'report', schema='ord', type_='foreignkey')
    op.drop_column('report', 'reporter_type', schema='ord')
    op.drop_column('report', 'settings_id', schema='ord')
    op.create_table('ad_distributor',
        sa.Column('id', sa.BIGINT(), server_default=sa.text("nextval('ord.ad_distributor_id_seq'::regclass)"), autoincrement=True, nullable=False),
        sa.Column('name', sa.TEXT(), autoincrement=False, nullable=False),
        sa.Column('display_name', sa.TEXT(), autoincrement=False, nullable=False),
        sa.Column('inn', sa.TEXT(), autoincrement=False, nullable=False),
        sa.Column('created_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text('now()'), autoincrement=False, nullable=False),
        sa.Column('updated_at', postgresql.TIMESTAMP(timezone=True), server_default=sa.text('now()'), autoincrement=False, nullable=False),
        sa.Column('agency_id', sa.BIGINT(), autoincrement=False, nullable=True),
        sa.Column('settings', postgresql.JSONB(astext_type=sa.Text()), server_default=sa.text("'{}'::jsonb"), autoincrement=False, nullable=False),
        sa.PrimaryKeyConstraint('id', name='ad_distributor__pk'),
        schema='ord'
    )
    op.create_foreign_key('report_ad_distributor_id__fk', 'report', 'ad_distributor', ['ad_distributor_id'], ['id'], source_schema='ord', referent_schema='ord')
    op.drop_table('report_settings', schema='ord')
    # ### end Alembic commands ###
